%gui_selections

load_default_options


SoundDir_gotten = 0; % uigetdir and uigetfile return "0" if the cancel button is pressed
h_gui_selections = fullscreenfigure;
set(h_gui_selections, 'Name', 'FormantMeasurer', 'NumberTitle', 'off');

while SoundDir_gotten == 0
    
    %blurb
    text(-0.05,1,'FormantMeasurer', 'FontName','Times', 'Fontsize',30, 'Units','normalized', 'HorizontalAlignment','left', 'VerticalAlignment','top');
    text(-0.05,0.025,'Release 2011-05-26', 'FontName','Times', 'Fontsize',10, 'Units','normalized', 'HorizontalAlignment','left', 'VerticalAlignment','top');
    text(-0.05,0,' Geoffrey Stewart Morrison & Terrance M. Nearey', 'FontName','Times', 'Fontsize',10, 'Units','normalized', 'HorizontalAlignment','left', 'VerticalAlignment','top');
    text(-0.05,-0.025,'http://geoff-morrison.net', 'FontName','Times', 'Fontsize',10, 'Units','normalized', 'HorizontalAlignment','left', 'VerticalAlignment','top');
    axis off

    % file options
    Bgroup_file_options = uibuttongroup('Title','File Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.1 .65 .375 .2]);
    B_process_dir = uicontrol('Style','Radio',...
                            'String','Process all the files in a directory',...
                            'Value',process_dir,...
                            'Units','normalized',...
                            'Position',[.05 .75 .9 .2],...
                            'Parent', Bgroup_file_options);
    B_process_file = uicontrol('Style','Radio',...
                            'String','Process a single file',...
                            'Value',~process_dir,...
                            'Units','normalized',...
                            'Position',[.05 .55 .9 .2],...
                            'Parent', Bgroup_file_options);
    P_file_filter = uipanel(Bgroup_file_options, 'Title', 'File filter', 'Position', [.05 .3 .9 .225], 'BorderType', 'none');
    B_file_filter = uicontrol('Style','Edit',...
                            'String',file_filter_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_file_filter);
    B_use_saved = uicontrol('Style','Check',...
                            'String','Use previously saved temporary formant-track files',...
                            'Value',use_saved_tracks,...
                            'Units','normalized',...
                            'Position',[.05 .05 .9 .2],...
                            'Parent', Bgroup_file_options);
                        
    % marker options
    Bgroup_marker_options = uibuttongroup('Title','Marker Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.1 .35 .375 .25]);
    B_use_fixed_trackmarks = uicontrol('Style','Radio',...
                            'String','Use ordinal track markers:',...
                            'Value',use_fixed_num_trackmarks,...
                            'Units','normalized',...
                            'Position',[.05 .825 .9 .15],...
                            'Parent', Bgroup_marker_options);
    B_trackmark_ordinals = uicontrol('Style','Edit',...
                            'String',trackmarks_to_use_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .7 .9 .15],...
                            'Parent', Bgroup_marker_options);
    B_use_labelled_trackmarks = uicontrol('Style','Radio',...
                            'String','Use track marker labels:',...
                            'Value',~use_fixed_num_trackmarks,...
                            'Units','normalized',...
                            'Position',[.05 .525 .9 .15],...
                            'Parent', Bgroup_marker_options);
    B_trackmark_labels = uicontrol('Style','Edit',...
                            'String',labels_to_measure_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[.05 .4 .9 .15],...
                            'Parent', Bgroup_marker_options);
    P_label_row_to_use = uipanel(Bgroup_marker_options, 'Title', 'Label row to use', 'Position', [.05 .05 .9 .3], 'BorderType', 'none');
    B_label_row_to_use = uicontrol('Style','List',...
                            'String','1|2|3',...
                            'Value',label_row_to_use,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_label_row_to_use);
                        
                        
    % formant measurement options
    B_formant_options = uibuttongroup('Title','Formant Measurement Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.525 .765 .375 .085]);
    P_min_cutoff = uipanel(B_formant_options, 'Title', 'Minimum F3-F4 cutoff (Hz)', 'Position', [.05 .2 .425 .7], 'BorderType', 'none');
    B_min_cutoff = uicontrol('Style','Edit',...
                            'String',min_f34cutoffs_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_min_cutoff);
    P_max_cutoff = uipanel(B_formant_options, 'Title', 'Maximum F3-F4 cutoff (Hz) {<=5000}', 'Position', [.5125 .2 .425 .7], 'BorderType', 'none');
    B_max_cutoff = uicontrol('Style','Edit',...
                            'String',max_f34cutoffs_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_max_cutoff);
                        
                        
   % amplitude measurement options
    B_amplitude_options = uibuttongroup('Title','Amplitude Measurement Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.525 .65 .375 .085]);
    P_window_length = uipanel(B_amplitude_options, 'Title', 'Window length (ms)', 'Position', [.05 .2 .425 .7], 'BorderType', 'none');
    B_window_length = uicontrol('Style','Edit',...
                            'String',window_length_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_window_length);
                        
   % fundamental frequency options
    B_group_pitch = uibuttongroup('Title','Fundametal Frequency Measurement Options',...
                            'FontSize',12,...
                            'Units','normalized',...
                            'Position',[.525 .25 .375 .35]);
    P_min_max_f0 = uipanel(B_group_pitch, 'Title', 'Min Maximum F0 (Hz)', 'Position', [.05 .8 .425 .15], 'BorderType', 'none');
    B_min_max_f0 = uicontrol('Style','Edit',...
                            'String',min_maxf0_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_min_max_f0);
    P_max_max_f0 = uipanel(B_group_pitch, 'Title', 'Max Maximum F0 (Hz)', 'Position', [.5125 .8 .425 .15], 'BorderType', 'none');
    B_max_max_f0 = uicontrol('Style','Edit',...
                            'String',max_maxf0_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_max_max_f0);
    P_min_min_f0 = uipanel(B_group_pitch, 'Title', 'Min Minimum F0 (Hz)', 'Position', [.05 .625 .425 .15], 'BorderType', 'none');
    B_min_min_f0 = uicontrol('Style','Edit',...
                            'String',min_minf0_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_min_min_f0);
    P_max_min_f0 = uipanel(B_group_pitch, 'Title', 'Max Minimum F0 (Hz)', 'Position', [.5125 .625 .425 .15], 'BorderType', 'none');
    B_max_min_f0 = uicontrol('Style','Edit',...
                            'String',max_minf0_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_max_min_f0);
    P_voice_thresh = uipanel(B_group_pitch, 'Title', 'Voice threshold {0..1}', 'Position', [.05 .45 .425 .15], 'BorderType', 'none');
    B_voice_thresh = uicontrol('Style','Edit',...
                            'String',VoicingThreshold_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_voice_thresh);
    P_silence_thresh = uipanel(B_group_pitch, 'Title', 'Silence threshold {0..1}', 'Position', [.5125 .45 .425 .15], 'BorderType', 'none');
    B_silence_thresh = uicontrol('Style','Edit',...
                            'String',SilenceThreshold_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_silence_thresh);
    P_voiced_voiceless = uipanel(B_group_pitch, 'Title', 'Voiced-voicelss cost {0..1}', 'Position', [.05 .275 .425 .15], 'BorderType', 'none');
    B_voiced_voiceless = uicontrol('Style','Edit',...
                            'String',VoicedUnvoicedCost_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_voiced_voiceless);
    P_octave_jump = uipanel(B_group_pitch, 'Title', 'Octave jump cost {0..1}', 'Position', [.05 .1 .425 .15], 'BorderType', 'none');
    B_octave_jump = uicontrol('Style','Edit',...
                            'String',OctaveJumpCost_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_octave_jump);
    P_octave = uipanel(B_group_pitch, 'Title', 'Octave cost {0..1}', 'Position', [.5125 .1 .425 .15], 'BorderType', 'none');
    B_octave = uicontrol('Style','Edit',...
                            'String',OctaveCost_str,...
                            'FontSize',8,...
                            'Units','normalized',...
                            'Position',[0 0 1 1],...
                            'Parent', P_octave);
                        
    invalid_input = true;
    while invalid_input
        
        % next button
        button_next;
        while nextb<=nextb_ref
            pause(0.1)
        end

        % extract values
        process_dir = logical(get(B_process_dir, 'Value'));
        file_filter_str = get(B_file_filter, 'String');
        use_saved_tracks = logical(get(B_use_saved, 'Value'));
        use_fixed_num_trackmarks = logical(get(B_use_fixed_trackmarks, 'Value'));
        trackmarks_to_use = round(abs(str2num(get(B_trackmark_ordinals, 'String'))));
        labels_to_measure = str2cell(get(B_trackmark_labels, 'String'));
        label_row_to_use = get(B_label_row_to_use, 'Value');
        min_f34cutoffs = abs(str2double(get(B_min_cutoff, 'String')));
        max_f34cutoffs = abs(str2double(get(B_max_cutoff, 'String')));
        window_length = abs(str2double(get(B_window_length, 'String')));
        min_minf0 = abs(str2double(get(B_min_min_f0, 'String')));
        max_minf0 = abs(str2double(get(B_max_min_f0, 'String')));
        min_maxf0 = abs(str2double(get(B_min_max_f0, 'String')));
        max_maxf0 = abs(str2double(get(B_max_max_f0, 'String')));
        VoicingThreshold = abs(str2double(get(B_voice_thresh, 'String')));
        SilenceThreshold = abs(str2double(get(B_silence_thresh, 'String')));
        OctaveJumpCost = abs(str2double(get(B_octave_jump, 'String')));
        VoicedUnvoicedCost = abs(str2double(get(B_voiced_voiceless, 'String')));
        OctaveCost = abs(str2double(get(B_octave, 'String')));

        % test values
        invalid_input = false;
        err_str = '';
        if use_fixed_num_trackmarks
            num_trackmarks = length(trackmarks_to_use);
            if isempty(trackmarks_to_use) || isodd(length(trackmarks_to_use)) || ~issequential(trackmarks_to_use)
                err_str = [err_str, 'Invalid ordinal track marker specification.\n'];
                invalid_input = true;
            end
        else
            num_labels = length(labels_to_measure);
            if isempty(labels_to_measure)
                err_str = [err_str, 'Invalid label specification.\n'];
                invalid_input = true;
            end
        end
        if isnan(min_f34cutoffs) || isnan(max_f34cutoffs) || min_f34cutoffs >= max_f34cutoffs || max_f34cutoffs >= 5000
            err_str = [err_str, 'Invalid F3-F4 cutoff specification.\n'];
            invalid_input = true;
        end
        if isnan(window_length) || window_length == 0
            err_str = [err_str, 'Invalid window length specification.\n'];
            invalid_input = true;
        end
        
        test_f0_values
        
        if invalid_input
            beep
            warndlg(sprintf(err_str), 'Invalid options', 'modal');
        end
    end

    % select the folder or individual file to load
    clf
    if process_dir
        [FileName, SoundDir] = strtok(fliplr(file_filter_str),'\');
        FileName = fliplr(FileName);
        SoundDir = fliplr(SoundDir);
        SoundDir_gotten = uigetdir(SoundDir,'Select the Folder Containing the Sound Files to Label');
    else
        [FileName,SoundDir_gotten,FilterIndex] = uigetfile(file_filter_str,'Select the Sound File to Label');
    end
    
    if SoundDir_gotten(1) ~= 0 && isempty(dir(fullfile(SoundDir_gotten, FileName))) % make sure that the folder actually contains files of the requested type
        SoundDir_gotten = 0;
    end
end
if SoundDir_gotten(end) ~= '\'
    SoundDir = [SoundDir_gotten, '\'];
else
    SoundDir = SoundDir_gotten;
end

% collate F0 options
% dwinMs=1000*3/minf0;
f0defaults = {min_minf0, max_minf0, min_maxf0, max_maxf0, VoicingThreshold, SilenceThreshold, OctaveJumpCost, VoicedUnvoicedCost, OctaveCost};

clf